using System.Windows.Forms;
using Microsoft.VisualBasic;
using System;
using StrataFlix.Business;


namespace StrataFlix
{
	public partial class CastMemberSelection
	{
		public CastMemberSelection()
		{
			InitializeComponent();
		}
		
		#region " Handled Events "
		
		private void cboCastType_SelectedIndexChanged(System.Object sender, System.EventArgs e)
		{
			if (((MovieCastType) cboCastType.SelectedValue) == MovieCastType.Actor)
			{
				txtCharacterName.Enabled = true;
				lblCharacterName.Enabled = true;
			}
			else
			{
				txtCharacterName.Enabled = false;
				lblCharacterName.Enabled = false;
				if (txtCharacterName.Text.Length > 0)
				{
					txtCharacterName.Text = "";
				}
			}
		}
		
		private void cmdOK_Click(object sender, System.EventArgs e)
		{
			if (MovieCast.CheckRules(true))
			{
				//-- If this is a new record, then retrieve the name in parts from the server for the person
				//   selected and ensure that the columns exist within the CurrentDataTable since this is generally
				//   part of the query.  If this was a new record and no query has been performed, these field parts
				//   may not be in the data table since they are not part of the structure of the MovieCast table.
				if (MovieCast.CurrentRow.RowState == System.Data.DataRowState.Added)
				{
					//-- Ensure that the columns exist within the data row
					Basics.EnsureColumnExists(MovieCast.CurrentDataTable, "pl_FirstName", typeof(string), "");
					Basics.EnsureColumnExists(MovieCast.CurrentDataTable, "pl_MiddleName", typeof(string), "");
					Basics.EnsureColumnExists(MovieCast.CurrentDataTable, "pl_LastName", typeof(string), "");
					
					using (PeopleBO bo = new PeopleBO())
					{
						//-- Get the people record
						bo.FillByPrimaryKey(PeopleLookupControl1.PrimaryKey);
						
						//-- See if there were any results
						if (bo.Count > 0)
						{
							MovieCast.CurrentRow["pl_FirstName"] = bo.pl_FirstName;
							MovieCast.CurrentRow["pl_MiddleName"] = bo.pl_MiddleName;
							MovieCast.CurrentRow["pl_LastName"] = bo.pl_LastName;
						}
					}
					
				}
				
				DialogResult = System.Windows.Forms.DialogResult.OK;
			}
		}
		
		private void cmdCancel_Click(System.Object sender, System.EventArgs e)
		{
			DialogResult = System.Windows.Forms.DialogResult.Cancel;
		}
		
		#endregion

        private void cboCastType_ListPopulating(MicroFour.StrataFrame.UI.ListPopulatingEventArgs e)
        {

        }
		
	}
	
}
